/*
 * Decompiled with CFR 0.152.
 */
package com.existingeevee.swparasites.items;

import com.dhanantry.scapeandrunparasites.init.SRPPotions;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfig;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfigSystems;
import com.existingeevee.swparasites.Utils;
import com.existingeevee.swparasites.config.ParasiteSWConfig;
import com.existingeevee.swparasites.handlers.EvolutionHandler;
import com.existingeevee.swparasites.items.IHasSRPEvolutionProgress;
import com.oblivioussp.spartanshields.item.ItemShieldBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ItemImpalerShield
extends ItemShieldBase
implements IHasSRPEvolutionProgress {
    float attackDamage = 21.0f;
    float falloffPerBlock = 3.0f;
    double maxRange = 5.0;
    double maxDeltaAngle = 0.7853981633974483;
    float power = 1.0f;

    public ItemImpalerShield(String unlocName, int maxDurability, float damage, float power, float range) {
        super(unlocName);
        this.attackDamage *= damage;
        this.power = power * power;
        this.maxRange *= (double)range;
        this.func_77656_e(maxDurability);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack item = playerIn.func_184586_b(handIn);
        if (!playerIn.func_70093_af() || !playerIn.field_70122_E) {
            return super.func_77659_a(worldIn, playerIn, handIn);
        }
        if (!worldIn.field_72995_K) {
            playerIn.field_70170_p.func_184148_a(null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, SoundEvents.field_187730_dW, SoundCategory.PLAYERS, 0.7f, this.power == 1.0f ? 1.25f : 0.75f);
        }
        Vec3d vec = playerIn.func_70040_Z();
        if (worldIn.field_72995_K) {
            playerIn.field_70159_w += vec.field_72450_a * 2.0 * (double)this.power;
            playerIn.field_70179_y += vec.field_72449_c * 2.0 * (double)this.power;
            playerIn.field_70133_I = true;
        }
        AxisAlignedBB box = new AxisAlignedBB(playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v).func_186662_g(this.maxRange);
        boolean hitAny = false;
        for (Entity entity : worldIn.func_175674_a((Entity)playerIn, box, e -> this.isValidTarget((Entity)e, playerIn))) {
            Vec3d eyePos = playerIn.func_174824_e(0.5f);
            Vec3d targetCenterPos = Utils.getCenter(entity.func_174813_aQ());
            float distanceTo = (float)eyePos.func_72438_d(targetCenterPos);
            boolean wasHit = entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)playerIn), this.attackDamage);
            if (!wasHit) continue;
            hitAny = true;
            Vec3d motionVector = new Vec3d(entity.field_70165_t - playerIn.field_70165_t, 0.0, entity.field_70161_v - playerIn.field_70161_v).func_72432_b().func_186678_a(1.5).func_186678_a(1.0 - (double)distanceTo / (this.maxRange * 2.0)).func_72441_c(0.0, 0.6, 0.0);
            if (!worldIn.field_72995_K) {
                entity.field_70159_w += motionVector.field_72450_a + 0.25 * (double)this.power;
                entity.field_70181_x += motionVector.field_72448_b * 0.5;
                entity.field_70179_y += motionVector.field_72449_c + 0.25 * (double)this.power;
                entity.field_70133_I = true;
                entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187767_eL, SoundCategory.PLAYERS, 0.7f, 1.0f);
            }
            item.func_77972_a(1, (EntityLivingBase)playerIn);
            if (!(((EntityLivingBase)entity).func_110143_aJ() <= 0.0f)) continue;
            ItemImpalerShield.add(item, (int)((EntityLivingBase)entity).func_110138_aP());
        }
        if (hitAny) {
            playerIn.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 20, 4));
        }
        playerIn.func_184811_cZ().func_185145_a(item.func_77973_b(), playerIn.func_70644_a(SRPPotions.RAGE_E) ? 25 : 50);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)item);
    }

    public static void add(ItemStack stack, int amount) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            compound = new NBTTagCompound();
        }
        if (compound.func_74764_b("srpkills")) {
            int key = compound.func_74762_e("srpkills") + amount;
            compound.func_74768_a("srpkills", key);
        } else {
            compound.func_74768_a("srpkills", amount);
        }
        stack.func_77982_d(compound);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void attackEvent(LivingAttackEvent ev) {
        if (ev.getEntityLiving() instanceof EntityPlayer) {
            ItemStack activeStack;
            EntityPlayer player = (EntityPlayer)ev.getEntityLiving();
            Entity entity = ev.getSource().func_76346_g();
            if (player.func_184587_cr() && !player.func_184607_cu().func_190926_b() && (activeStack = player.func_184607_cu()).func_77973_b() == this && player.func_184583_d(ev.getSource())) {
                if (entity != null) {
                    entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), this.attackDamage / 2.0f);
                    if (((EntityLivingBase)entity).func_110143_aJ() <= 0.0f) {
                        ItemImpalerShield.add(activeStack, (int)((EntityLivingBase)entity).func_110138_aP());
                    }
                }
                if (this.power == 1.0f) {
                    NBTTagCompound compound = activeStack.func_77978_p();
                    if (compound == null) {
                        compound = new NBTTagCompound();
                    }
                    if (compound.func_74764_b("srpkills")) {
                        int key = (int)((float)compound.func_74762_e("srpkills") + ev.getAmount());
                        compound.func_74768_a("srpkills", key);
                    } else {
                        compound.func_74768_a("srpkills", (int)ev.getAmount() / 2);
                    }
                    activeStack.func_77982_d(compound);
                }
            }
        }
    }

    private boolean isValidTarget(Entity target, EntityPlayer player) {
        Vec3d targetDirection;
        if (target == null || player == null) {
            return false;
        }
        Vec3d eyePos = player.func_174824_e(0.5f);
        Vec3d targetCenterPos = Utils.getCenter(target.func_174813_aQ());
        Vec3d lookVec = player.func_70040_Z();
        double deltaAngle = Math.abs(Math.acos(lookVec.func_72430_b(targetDirection = targetCenterPos.func_178788_d(eyePos).func_72432_b())));
        if (deltaAngle > this.maxDeltaAngle) {
            return false;
        }
        RayTraceResult result = Utils.rayTrace(eyePos, targetDirection, player.field_70170_p, this.maxRange, e -> e != target, true, true);
        if (result.field_72308_g != target) {
            return false;
        }
        return target instanceof EntityLivingBase;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!worldIn.field_72995_K) {
            if (ParasiteSWConfig.sentientScent && (double)this.power == 1.5 && SRPConfigSystems.useScent && worldIn.field_73012_v.nextInt(100) == 0 && entityIn.field_70173_aa % 40 == 0) {
                ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(SRPPotions.PREY_E, 1200, 0, false, false));
            }
            if (entityIn.field_70173_aa % 80 == 0) {
                int key = 0;
                NBTTagCompound compound = stack.func_77978_p();
                if (compound != null && EvolutionHandler.getEvolved(stack.func_77973_b()) != null) {
                    if (compound.func_74764_b("srpkills")) {
                        key = compound.func_74762_e("srpkills");
                    }
                    if (key > SRPConfig.weapon_livingSentient_HP_needed) {
                        compound.func_74768_a("srpkills", 0);
                        ItemStack stackW = new ItemStack(EvolutionHandler.getEvolved(stack.func_77973_b()), 1);
                        if (ParasiteSWConfig.evolutionKeepNBT) {
                            stackW.func_77982_d(compound.func_74737_b());
                        }
                        EntityItem entityitem = new EntityItem(worldIn, entityIn.field_70165_t, entityIn.field_70163_u, entityIn.field_70161_v, stackW);
                        if (ParasiteSWConfig.evolutionDropOnGround) {
                            entityitem.func_174869_p();
                        } else {
                            entityitem.func_174868_q();
                        }
                        worldIn.func_72838_d((Entity)entityitem);
                        stack.func_190918_g(1);
                        if (SRPConfig.thunderEnable) {
                            worldIn.func_72942_c((Entity)new EntityLightningBolt(worldIn, entityIn.field_70165_t, entityIn.field_70163_u, entityIn.field_70161_v, true));
                        }
                    }
                }
            }
        }
    }
}

